import { ReactNode } from 'react';
import { EEvictionState, EPodCurrentState, EResourceKind, ESchedulingState } from '../../../proto-typings';
import { ResourceBarProps } from '../ResourceBar/ResourceBar';

export type RowItemData = {
   podResourceUsage: PodResourceUsage;
   podSetId: string;
   podId: string;
   eviction: EEvictionState;
   state: EPodCurrentState;
   scheduling: ESchedulingState;
   schedulingLastUpdated?: Date;
   serviceOrStage?: string;
};

export interface TableRowItem {
   data: RowItemData;
   podId: ReactNode;
   podSetId: ReactNode;
   state: ReactNode;
   eviction: ReactNode;
   scheduling: ReactNode;
   schedulingLastUpdated: ReactNode;
   serviceOrStage?: ReactNode;
   cpu: ReactNode;
   memory: ReactNode;
   network: ReactNode;
   hdd: ReactNode;
   hddBandwidth: ReactNode;
   ssd: ReactNode;
   ssdBandwidth: ReactNode;
   cpuModel: ReactNode;
}

export interface ResourceUsageBase {
   kind: EResourceKind;
   total: number;
}

export interface DiskResourceUsage extends ResourceUsageBase {
   bandwidth: number;
   storageClass: string;
}

export interface PodResourceUsage {
   hdd?: DiskResourceUsage;
   ssd?: DiskResourceUsage;
   cpu?: ResourceUsageBase;
   memory?: ResourceUsageBase;
   network?: ResourceUsageBase;
}

type UsageKey = keyof PodResourceUsage;

export type PodUsageProps = Record<UsageKey, ResourceBarProps | undefined> & {
   hddBandwidth?: ResourceBarProps;
   ssdBandwidth?: ResourceBarProps;
};
