import React, { ReactNode } from 'react';
import { TReplicaSet } from '../../../proto-typings';
import { RevisionPodsStatus } from '../RevisionPodsStatus/RevisionPodsStatus';
import { RevisionsProgressStatus } from '../RevisionsProgressStatus/RevisionsProgressStatus';
import classes from './ReplicaSetPodsInfo.module.css';

interface Props {
   replicaSet: TReplicaSet;
}

export const ReplicaSetPodsInfo: React.FC<Props> = ({ replicaSet }) => {
   const { status } = replicaSet;

   let revisionProgressStatus: ReactNode;

   const deployStatus = status?.deploy_status;

   const { pods_total = 0, pods_ready = 0, pods_in_progress = 0, pods_failed = 0 } =
      deployStatus?.details?.total_progress ?? {};

   const details = deployStatus?.details;

   const mappedRevisions = details?.mapped_revisions;
   if (!mappedRevisions) {
      return null;
   }

   const revisionItems = Object.keys(mappedRevisions).map(key => {
      const value = mappedRevisions[key];
      return (
         <RevisionPodsStatus
            key={key}
            revision={Number(key)}
            failed={value?.pods_failed ?? 0}
            ready={value?.pods_ready ?? 0}
            inProgress={value?.pods_in_progress ?? 0}
            total={value?.pods_total ?? 0}
            className={classes.revision}
         />
      );
   });

   if (pods_total !== 0) {
      revisionProgressStatus = (
         <RevisionsProgressStatus
            total={pods_total}
            failed={pods_failed}
            inProgress={pods_in_progress}
            ready={pods_ready}
            className={classes.progress}
         />
      );
   }

   return (
      <div className={classes.pods}>
         <div className={classes.podsTitle}>Pods statuses</div>
         {revisionProgressStatus}
         {revisionItems.length > 0 && <div className={classes.revisionsList}>{revisionItems}</div>}
      </div>
   );
};
