import { Progress, ProgressView } from '@yandex-cloud/uikit';
import { classNames, formatNumber } from '@yandex-infracloud-ui/libs';
import React from 'react';

import classes from './ResourceBar.module.css';

const colorStops = [
   { theme: 'success' as const, stop: 80 },
   { theme: 'warning' as const, stop: 95 },
   { theme: 'danger' as const, stop: 100 },
];

export interface ResourceBarProps {
   title?: string;
   total: number;
   used: number;
   free?: number;
   format?: string;
   suffix?: string;
   view?: ProgressView;
   className?: string;
}

export const ResourceBar: React.FC<ResourceBarProps> = React.memo(
   ({ title, total, used, free, format, suffix, view = 'thin', className }) => {
      const freeTitle = format && free ? formatNumber(free, format) : free;
      const totalStr = format ? formatNumber(total, format) : total;
      const usedStr = format ? formatNumber(used, format) : used;
      const value = Math.min((used / total) * 100, 100);

      const isOvercommit = used > total;
      const freeOrOvercommitText = isOvercommit ? 'overcommit' : 'free';
      const overcommitTitle = format ? formatNumber(used - total, format) : used - total;
      const freeOrOvercommitTitle = isOvercommit ? overcommitTitle : freeTitle;

      return (
         <div className={classNames(classes.row, className)}>
            {title && <div className={classes.rowTitle}>{title}</div>}
            <div className={classes.bar}>
               <div className={classes.barTitle}>
                  <span className={classNames(classes.valueTitle, classes.usedTitle)}>
                     {usedStr}
                     {suffix}
                     {(isOvercommit || free !== undefined) && (
                        <span className={classNames(isOvercommit ? classes.overcommitTitle : classes.freeTitle)}>
                           ({freeOrOvercommitTitle}
                           {suffix} {freeOrOvercommitText})
                        </span>
                     )}
                  </span>
                  <span className={classes.valueTitle}>
                     {totalStr}
                     {suffix}
                  </span>
               </div>
               <Progress value={value} colorStops={colorStops} view={view} />
            </div>
         </div>
      );
   },
);

ResourceBar.displayName = 'ResourceBar';
