import React from 'react';

import { classNames } from '@yandex-infracloud-ui/libs';

import { Status, StatusState } from '../../lib';

import classes from './RevisionPodsStatus.module.css';

interface Props {
   revision: number;
   inProgress: number;
   ready: number;
   failed: number;
   total: number;
   className?: string;
}

export const RevisionPodsStatus: React.FC<Props> = ({ revision, inProgress, ready, failed, total, className }) => (
   <div className={classNames(classes.revision, className)}>
      <div className={classes.title}>
         Revision {revision} ({total} pods total)
      </div>
      <div className={classes.row}>
         <Status state={StatusState.Ok} isAnimated={false}>
            Ready pods
         </Status>
         <span>{ready}</span>
      </div>
      <div className={classes.row}>
         <Status state={StatusState.Progress} isAnimated={false}>
            Deploying pods
         </Status>
         <span>{inProgress}</span>
      </div>
      <div className={classes.row}>
         <Status state={StatusState.Error} isAnimated={false}>
            Failed pods
         </Status>
         <span>{failed}</span>
      </div>
   </div>
);
