import { Progress } from '@yandex-cloud/uikit';
import { classNames } from '@yandex-infracloud-ui/libs';
import React from 'react';

import classes from './RevisionsProgressStatus.module.css';

interface Props {
   total: number;
   ready: number;
   inProgress: number;
   failed: number;
   className?: string;
}

export const RevisionsProgressStatus: React.FC<Props> = ({ total, ready, failed, className }) => {
   const readyPercent = (ready / total) * 100;
   const failedPercent = (failed / total) * 100;
   const inProgressPercent = 100 - readyPercent - failedPercent;
   return (
      <div className={className}>
         <div className={classes.title}>{total} total</div>
         <div className={classNames(classes.barContainer)}>
            <Progress
               view={'thinnest'}
               stack={[
                  { value: readyPercent, color: 'var(--yc-color-base-positive-heavy)' },
                  { value: failedPercent, color: 'var(--yc-color-base-danger-heavy)' },
                  { value: inProgressPercent, color: 'var(--yc-color-base-info-heavy)' },
               ]}
            />
         </div>
      </div>
   );
};
