import { classNames, Json, SmartTab, SmartTabsWithUrl } from '@yandex-infracloud-ui/libs';
import React, { ReactNode } from 'react';

import classes from './Tabs.module.css';

export interface Tab {
   content?: ReactNode;
   id: string;
   obj?: any;
   title: ReactNode;
   width?: 'normal' | 'full';
}

interface Props {
   tabs: Tab[];
   defaultTab?: string;
}

export const Tabs: React.FC<Props> = ({ tabs, defaultTab }) => {
   if (!tabs.length) {
      return null;
   }

   const defaultTabId = defaultTab || tabs[0].id;

   return (
      <div className={classes.tabs}>
         <SmartTabsWithUrl defaultTab={defaultTabId}>
            {tabs
               // Пропускаем вкладки без контента
               .filter(({ content, obj }) => content || obj)
               .map(({ id, title, content, obj, width = 'normal' }) => (
                  <SmartTab key={id} id={id} title={title}>
                     <div className={classNames(classes.jsonFix, { [classes.tabContent]: width === 'normal' })}>
                        {content ?? (obj !== undefined ? <Json obj={obj} /> : null)}
                     </div>
                  </SmartTab>
               ))}
         </SmartTabsWithUrl>
      </div>
   );
};

Tabs.displayName = 'Tabs';
