/// <reference path="./typings/deploy.d.ts" />
/// <reference path="./typings/lego-on-react.d.ts" />
/// <reference path="./typings/prismjs.d.ts" />
/// <reference path="./typings/react-diff-view.d.ts" />
/// <reference path="./typings/refractor.d.ts" />
/// <reference path="./typings/unidiff.d.ts" />
/// <reference path="./typings/unipika.d.ts" />
import { configure, Lang, ThemeProvider } from '@yandex-cloud/uikit';
import { configure as commonConfigure, Lang as CommonLang } from '@yandex-data-ui/common/build/esm/utils/configure';
import { ErrorBoundary, initMetrika, ProjectContext } from '@yandex-infracloud-ui/libs';
import moment from 'moment';
import React from 'react';
import ReactDOM from 'react-dom';
import { Provider } from 'react-redux';
import { BrowserRouter } from 'react-router-dom';
import { BehaviorSubject } from 'rxjs';

import './design/index.css';
/* App должен импортироваться строго после стилей */
import { App } from './_layout/App/App';

import { NotificationsContext as NotificationsContextNew, urlBuilder } from './models';

import { API } from './old-code/services/api';
import Notifications, { NotificationsContext as NotificationsContextOld } from './old-code/services/Notifications';
import { configureStore } from './redux';
import reportWebVitals from './reportWebVitals';
import { ApiServices, ApiServicesContext, Config, ConfigContext, Ebooster, TestActions, Yasm } from './services';

const api = new API();
const notifications = new Notifications();
const config = new Config(window.CONFIG, window.USER);

const apiServices = new ApiServices(config);
const ebooster = new Ebooster(config);
const yasm = new Yasm(config);
const store = configureStore({ api, notifications });
const newVersion = new BehaviorSubject<boolean>(false);

// Common library i18n
configure({ lang: Lang.En }); // for uikit
commonConfigure({ lang: CommonLang.En }); // for common

moment.locale('en');

window.testActions = new TestActions();

if (config.metrika) {
   initMetrika(config.metrika);
}

console.log('Config is', config);

ebooster.init();
yasm.init();

ReactDOM.render(
   <ProjectContext.Provider
      value={{
         name: process.env.REACT_APP_NAME ?? 'Set REACT_APP_NAME env',
         homeUrl: urlBuilder.home(),
         feedbackFormId: config.feedbackFormId ?? undefined,
         onError: e => ebooster.sendError(e),
      }}
   >
      <ConfigContext.Provider value={config}>
         <BrowserRouter basename={process.env.PUBLIC_URL}>
            <ErrorBoundary>
               <Provider store={store}>
                  <NotificationsContextNew.Provider value={notifications}>
                     {/* TODO выкинуть этот контекст, заменить на новый (в идеале вообще выкинуть notifications) */}
                     <NotificationsContextOld.Provider value={notifications}>
                        <ApiServicesContext.Provider value={apiServices}>
                           <ThemeProvider theme={'light'}>
                              <React.StrictMode>
                                 <App user={config.user} newVersion={newVersion} />
                              </React.StrictMode>
                           </ThemeProvider>
                        </ApiServicesContext.Provider>
                     </NotificationsContextOld.Provider>
                  </NotificationsContextNew.Provider>
               </Provider>
            </ErrorBoundary>
         </BrowserRouter>
      </ConfigContext.Provider>
   </ProjectContext.Provider>,
   document.getElementById('root'),
);

// If you want your app to work offline and load faster, you can change
// unregister() to register() below. Note this comes with some pitfalls.
// Learn more about service workers: https://bit.ly/CRA-PWA
// serviceWorkerRegistration.unregister();
// serviceWorkerRegistration.register({
//    refreshInterval: config.serviceWorkerRefreshInterval,
//    onUpdate() {
//       newVersion.next(true);
//    },
// });

// If you want to start measuring performance in your app, pass a function
// to log results (for example: reportWebVitals(console.log))
// or send to an analytics endpoint. Learn more: https://bit.ly/CRA-vitals
reportWebVitals();
