import { registerYamlJSONSchema } from '@yandex-infracloud-ui/monaco-editor';
import type { SchemasSettings } from 'monaco-yaml';
import { memoAsyncEffect } from '../utils';
import { addNullable, transformEnum } from './transform';

export const deployJSONUri = 'https://deploy.yandex-team.ru';

export const getDeployJSONUri = (path: string) => `${deployJSONUri}${path}`;

const registredSchemas = new Set<string>();

async function registerJSONSchema(path: string, getSchema: () => Promise<SchemasSettings['schema']>) {
   if (registredSchemas.has(path)) {
      return;
   }
   registredSchemas.add(path);
   const schema = await getSchema();
   transformEnum(schema);
   addNullable(schema);
   const uri = getDeployJSONUri(path);
   await registerYamlJSONSchema({
      schemaSettings: {
         fileMatch: [`${uri}*`], // all by prefix
         uri,
         schema,
      },
   });
}

export const JSONSchemasByPath: Record<string, () => Promise<SchemasSettings['schema']>> = {
   '/yp/TStage': memoAsyncEffect(() => import('./stage/TStage.json').then(module => module.default) as any),
   '/yp/TStageSpec': memoAsyncEffect(() => import('./stage/TStageSpec.json').then(module => module.default) as any),
};

export async function registerJSONSchemaByPath(path: string) {
   const getSchema = JSONSchemasByPath[path];
   if (!getSchema) {
      return;
   }
   await registerJSONSchema(path, getSchema);
}
