/**
 * парсит enum примерно для аркадийных значений
 *
 * полностью совпадает с таковыми в спеке стейджа, в целом нужно переделать!
 */
export function transformEnum(object: any) {
   if (typeof object !== 'object' || object === null) {
      return;
   }
   if (Array.isArray(object)) {
      return;
   }
   if ('enum' in object && Array.isArray(object.enum)) {
      if (object.enum.length === 0) {
         return;
      }
      object.enum = object.enum.map((e: string) => e.toLowerCase().replace(/^[a-z]+_/, ''));
   }

   for (const name of Object.keys(object)) {
      transformEnum(object[name]);
   }
}

export function addNullable(object: any) {
   if (typeof object !== 'object' || object === null) {
      return;
   }
   if (Array.isArray(object)) {
      return;
   }
   if ('type' in object && object.type !== 'null') {
      object.oneOf = [{ type: object.type }, { type: 'null' }];
      delete object.type;
   }

   for (const name of Object.keys(object)) {
      addNullable(object[name]);
   }
}
