import { Meta } from '@storybook/react';
import { ExternalLink } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { EXTERNAL_LINKS } from './EXTERNAL_LINKS';

const LinkLists = ({ links }: { links: Record<string, string> }) => (
   <ul>
      {Object.entries(links).map(([name, link]) => (
         <li key={name}>
            <ExternalLink href={link}>{name}</ExternalLink>
         </li>
      ))}
   </ul>
);

export const Docs = () => (
   <>
      <h1>Docs</h1>
      <LinkLists links={EXTERNAL_LINKS.docs} />
   </>
);

export const DeployDocs = () => (
   <>
      <h1>Deploy docs</h1>
      <LinkLists links={EXTERNAL_LINKS.deployDocs} />
   </>
);

export const Wiki = () => (
   <>
      <h1>Wiki</h1>
      <LinkLists links={EXTERNAL_LINKS.wiki} />
   </>
);

export default {
   title: 'models/EXTERNAL_LINKS',
} as Meta;
