import { getHexRef } from '../utils';

const docs = (page: string) => `https://docs.yandex-team.ru/${page}`;

const deployDocs = (page: string) => `https://deploy.yandex-team.ru/docs/${page}`;

const wiki = (page: string) => `https://wiki.yandex-team.ru/${page}`;

const docsPages = {
   jugglerBundlerBuild: docs('juggler/client/bundles#how-to-build'),
   rtcDockerImages: docs('rtc/containers/virtual-images#docker'),
   rtcImages: docs('rtc/containers/virtual-images'),
   rtcQuotas: docs('rtc/quotas'),
   sandboxResourceAttributes: docs('sandbox/resources#attributes'),
};

// noinspection SpellCheckingInspection
const deployDocsPages = {
   accessPermissions: deployDocs('launch/sox-service#ustanovka-sekyurnyh-prav-na-staticheskie-resursy'),
   layers: deployDocs('concepts/pod/podagentpayload/resources/layer'),
   layerSourceFileStoragePolicy: deployDocs(
      'concepts/pod/podagentpayload/resources/layer#mehanizm-sohraneniya-ishodnogo-fajla-layer-posle-importa-v-porto',
   ),
   bindSkynet: deployDocs('concepts/pod/box#hostovyj-skynet'),
   box: deployDocs('concepts/pod/box'),
   boxEnvironment: deployDocs('concepts/pod/box#peremennye-okruzheniya'),
   coredump: deployDocs('concepts/pod/sidecars/coredump'),
   cgroupfs: deployDocs('concepts/pod/box#cgroupfs'),
   dctl: deployDocs('reference/tools/dctl'),
   deployRoleModel: deployDocs('reference/access-management/rbac'),
   diskVolumeRequests: deployDocs('concepts/pod/diskvolumerequests'),
   docker: deployDocs('concepts/stage/ispolzovanie-docker-obraza'),
   dynamicResources: deployDocs('concepts/dynamic-resources'),
   index: deployDocs(''),
   jugglerAgent: deployDocs('concepts/pod/sidecars/jugglersubagent'),
   logbrokerToolsChangelog: deployDocs('unified_agent/release_notes'),
   logrotateConfig: deployDocs('concepts/pod/sidecars/logrotate'),
   logs: deployDocs('concepts/pod/sidecars/logs/logs'),
   logsCustomTopicRequest: deployDocs('concepts/pod/sidecars/logs/logs#5.2.-polzovatelskij-topik-(beta)'),
   logsDestroyPolicy: deployDocs('concepts/pod/sidecars/logs/logs#8.2-polzovatelskie-nastrojki-destroy-policy'),
   logsCustomResources: deployDocs('concepts/pod/sidecars/logs/logs#custom-resources'),
   logsCustomCpu: deployDocs('concepts/pod/sidecars/logs/logs#custom-cpu'),
   logsQuota: deployDocs('concepts/pod/sidecars/logs/logs#1.1.-resursy'),
   migrationToDeploy: deployDocs('how-to/migration/success-stories'),
   nat64: deployDocs('concepts/pod/box#podklyuchenie-nat64-(v-box-i-vseh-vlozhennyh-v-nego-workload)'),
   patchersRevision: deployDocs('reference/patchers-revision'),
   // patchersRevisionUrl: (revision: number) => deployDocs(`reference/patchers-revision#runtime-version-${revision}`),
   pod: deployDocs('concepts/pod/pod'),
   podAgent: deployDocs('reference/pod-agent-releases'),
   probeTimeLimit: deployDocs('concepts/pod/workload/probes#ttimelimit'),
   project: deployDocs('concepts/project'),
   quota: deployDocs('reference/quotas-and-limits'),
   readonlyRootfs: deployDocs('launch/sox-service#read-only-rootfs-dlya-kontejnerov-boksov'),
   releaseIntegration: deployDocs('concepts/release-integration/release-integration'),
   resolvConf: deployDocs('concepts/pod/box#podklyuchenie-nat64-(v-box-i-vseh-vlozhennyh-v-nego-workload)'),
   resourceRequests: deployDocs('concepts/pod/resource-requests'),
   resourceUrl: deployDocs('concepts/pod/podagentpayload/resources/resource-url'),
   revision: deployDocs('concepts/stage/stage#pro-revizii'),
   secrets: deployDocs('how-to/secrets'),
   sidecarQuota: deployDocs('concepts/pod/sidecars/sidecars#kvota-dlya-sajdkarov'),
   sox: deployDocs('launch/sox-service'),
   stageHealth: deployDocs('reference/stage-health'),
   staticResources: deployDocs('concepts/pod/podagentpayload/resources/staticresource'),
   transferToProject: deployDocs('concepts/project#perenos-stejdzha-v-novyj-proekt'),
   transmitSystemLogs: deployDocs('concepts/pod/sidecars/logs/logs#system-logs'),
   tvmQuota: deployDocs('concepts/pod/sidecars/tvmtool'),
   volume: deployDocs('concepts/pod/volume'),
   workloadCommands: deployDocs('concepts/pod/workload/probes'),
   workloadEnvironment: deployDocs('concepts/pod/workload/workload#system_env'),
   yasmTagsInheritance: deployDocs('launch/monitorings#workload-metrics'),
   yasmUnistat: deployDocs('launch/monitorings'),
};

// noinspection SpellCheckingInspection
const wikiPages = {
   anonymousMemoryLimit: wiki('porto/memory/#anon'),
   awacsLimitations: wiki('awacs/tutorial/dns-balancing-in-awacs/#limitations'),
   awacsPuncher: wiki('awacs/tutorial/dns-balancing-in-awacs/#puncher'),
   createNetworkMacro: wiki('NOC/newnetwork/hbf/projectid/project-id-allocation/#opisanieformy'),
   infra: wiki('infra/#deploy-infra-integration'),
   jugglerAgent: wiki('sm/juggler/'),
   nda: wiki('nda'),
   projectNetwork: wiki('NOC/newnetwork/hbf/projectid/project-id-allocation/'),
   removeBalancer: wiki('cplb/awacs/tutorial/delete/'),
   tvm: wiki('passport/tvm2/tvm-daemon/'),
   xRay: wiki('security/x-ray/'),
   ypApi: wiki('yp/api/'),
   ypFreeTier: wiki('ftq/yp/'),
};

export const EXTERNAL_LINKS = {
   docs: docsPages,
   deployDocs: deployDocsPages,
   wiki: wikiPages,

   abcService: (service: string | number) => `https://abc.yandex-team.ru/services/${service}`,
   abcQuotaRequest: (serviceId: number) =>
      `${EXTERNAL_LINKS.abcService(
         serviceId,
      )}/resources/?new-resource-service=${serviceId}&new-resource=yes&new-resource-resource=96`,
   awacsNamespace: (namespace: string) => `https://nanny.yandex-team.ru/ui/#/awacs/namespaces/list/${namespace}/show/`,
   infra: () => 'https://infra.yandex-team.ru',
   infraServiceEnvironments: (service: number) => `https://infra.yandex-team.ru/services/${service}/environments`,
   logsYT: () => 'https://yt.yandex-team.ru/arnold/navigation?path=//logs/deploy-logs',
   monitoringService: (service: string) => `https://monitoring.yandex-team.ru/projects/${service}`,
   alertsList: (du: string, stage: string, project: string) =>
      `https://solomon.yandex-team.ru/admin/projects/${project}/alerts?text=${stage}.${du}&templateServiceProviderId=deploy`,
   nannyService: (serviceId: string) => `https://nanny.yandex-team.ru/ui/#/services/catalog/${serviceId}/`,
   qypVm: (cluster: string, vmId: string) => `https://qyp.yandex-team.ru/vm/${cluster}/${vmId}`,
   sandboxResource: (id: number) => `https://sandbox.yandex-team.ru/resource/${id}/view`,
   sandboxTask: (taskId: string) => `https://sandbox.yandex-team.ru/task/${taskId}/view`,
   secretLink: (secretUuid: string) => `https://yav.yandex-team.ru/secret/${secretUuid}`,
   secretVersion(secretUuid: string, versionId: string) {
      return `${this.secretLink(secretUuid)}/explore/version/${versionId}`;
   },
   startrekTicket: (id: string) => `https://st.yandex-team.ru/${id}`,
   walleNode: (nodeId: string) => `https://wall-e.yandex-team.ru/host/${nodeId}`,
   xRayAnalysis: (id: string, uuid: string, revision: number) =>
      `https://xray.sec.yandex-team.ru/stage/${id}/${uuid}/${revision}`,
   yqlStageLogsQuery: (stage: string, project: string) =>
      `https://yql.yandex-team.ru?query=USE \`arnold\`; SELECT * FROM RANGE(\`logs/deploy-logs/30min\`) WHERE \`stage\` = '${stage}' AND \`project\` = '${project}';`,

   // monitoring links
   yasmPanel(panel: string, panelParams: Record<string, string>, embed: boolean) {
      const params = Object.keys(panelParams)
         .filter(key => panelParams[key] !== undefined)
         .map(key => `${key}=${panelParams[key]}`)
         .join(';');

      return `https://yasm.yandex-team.ru/template/panel/${panel}/${params}/${embed ? '?embed=1' : ''}`;
   },
   logsPanel(panelParams: Record<string, string>) {
      const params = Object.keys(panelParams)
         .filter(key => panelParams[key] !== undefined)
         .map((key, i) => `${key}=${encodeURIComponent(panelParams[key])}`)
         .join('&');

      return `https://monitoring.yandex-team.ru/embed/yd/dash/monm7pfn6aj41fek8r7p/?${params}`;
   },
   idm() {
      return `https://idm.yandex-team.ru`;
   },
   idmRequestRole(params: {
      system: string;
      path: string;
      groups?: string[];
      users?: string[];
      expireDate?: string;
      expireDays?: number;
      comment?: string;
   }) {
      const { system, path, groups, users, expireDate, expireDays, comment } = params;
      const idmUrl = this.idm();
      const formId = getHexRef().substring(0, 8);
      const commentPart = comment ? `comment:${comment}` : '';
      const expireDatePart = expireDate && !expireDays ? `expireDate:${expireDate}` : '';
      const expireDaysPart = expireDays ? `expireDays:${expireDays}` : '';
      const paramsList = [commentPart, expireDatePart, expireDaysPart].filter(param => param.length > 0);
      const paramsPart = paramsList.length > 0 ? `(${paramsList.join(';')})` : '';
      const rolePart = `${system}${path}`;
      const getFormPart = (str: string) => `rf-role=${formId}#${str}`;
      const roleWithParamsPart = `${rolePart}${paramsPart}`;
      const usersPart = users?.map(login => getFormPart(`user:${login}@${roleWithParamsPart}`)).join(',') ?? '';
      const groupsPart = groups?.map(groupId => getFormPart(`group:${groupId}@${roleWithParamsPart}`)).join(',') ?? '';
      const itemsPart = [usersPart, groupsPart].filter(part => part.length > 0).join(',');
      return `${idmUrl}/systems#rf=1,${itemsPart},rf-expanded=${formId}`;
   },
   idmRequestDeployRole(params: {
      role: string;
      projectId: string;
      stageId?: string;
      system?: string;
      groups?: string[];
      users?: string[];
      expireDate?: string;
      expireDays?: number;
      comment?: string;
   }) {
      const { system = 'deploy-prod', projectId, stageId, role, ...other } = params;
      const stagePart = stageId ? `/${stageId}` : '';
      return this.idmRequestRole({ ...other, system, path: `/${projectId}${stagePart}/${role}` });
   },
};
