/*
Класс для работы с localStorage
*/

export class Storage {
   public getItem<T>(key: string, defaultValue: T): T {
      const fromStorage = localStorage.getItem(key);

      return fromStorage ? JSON.parse(fromStorage) : defaultValue;
   }

   public setItem<T>(key: string, value: T): void {
      localStorage.setItem(key, JSON.stringify(value));
   }

   public hasItem(key: string): boolean {
      return key in localStorage;
   }
}
