export interface ApiErrorItem {
   body: string;
   resp?: Response;
}

export type ApiErrorItemWithData<Data> = ApiErrorItem & {
   data?: Data;
};

export type ApiErrorItemWithMetaData<Data, MetaData> = ApiErrorItemWithData<Data> & {
   requestMetaData?: MetaData;
};

interface PrepareApiErrorProps<Data, MetaData> {
   error: ApiErrorItemWithData<Data> | Error;
   requestMetaData: MetaData;
   errorName?: string;
}
export function prepareApiError<Data, MetaData>({
   error,
   requestMetaData,
   errorName,
}: PrepareApiErrorProps<Data, MetaData>): ApiErrorItemWithMetaData<Data, MetaData> & Error {
   const isJsError = error instanceof Error;
   if (isJsError) {
      console.error(error);
   }
   const apiError: ApiErrorItemWithData<Data> = {
      ...(isJsError
         ? {
              body: (error as Error).message,
           }
         : (error as ApiErrorItem)),
      ...(isJsError ? {} : { data: (error as ApiErrorItemWithData<Data>).data }),
   };

   const newError = new Error(errorName ?? 'Api Error') as ApiErrorItemWithMetaData<Data, typeof requestMetaData> &
      Error;
   Object.assign(newError, {
      ...apiError,
      requestMetaData,
   });

   return newError;
}
