import { YpApiParams } from '.';
import { ApiServiceName } from './ApiServiceName';
import { AwacsApiActions, AwacsApiParams, YpApiActions } from './services';

export interface ApiParams<Req, Rsp> {
   request: Req;
   response: Rsp;
}

interface KnownApiActions {
   [ApiServiceName.YP]: YpApiActions;
   [ApiServiceName.AWACS]: AwacsApiActions;
}

export type ApiActions = KnownApiActions & Record<Exclude<ApiServiceName, keyof KnownApiActions>, any>;

interface KnownApiData {
   [ApiServiceName.YP]: YpApiParams;
   [ApiServiceName.AWACS]: AwacsApiParams;
}

type unknownApiDataServiceNames = Exclude<ApiServiceName, keyof KnownApiData>;
export type ApiData = KnownApiData &
   (unknownApiDataServiceNames extends never ? unknown : Record<unknownApiDataServiceNames, any>);

export interface ApiRequest<
   Service extends ApiServiceName,
   Action extends keyof ApiData[Service],
   R extends 'request' & keyof ApiData[Service][Action]
> {
   action: Action;
   data: ApiData[Service][Action][R];
   params?: Record<string, any>;
   pathParams?: Record<string, string>;
   headers?: Record<string, string>;
}

export interface ApiRequestMixin {
   requestKey?: string;
}

export interface RequestMetaData<Service extends ApiServiceName, Action extends keyof ApiData[Service] | string, Data> {
   service: Service;
   action: Action;
   requestData: Data;
   url: string;
   headers: Record<string, string>;
}

export interface RequestTimeoutData {
   url: string;
   requestKey?: string;
   requestData: object;
}

export enum RequestTimeoutState {
   Short,
   Long,
}

export type RequestTimeoutItem = RequestTimeoutData & {
   timestamp: number;
   abort?(): void;
   aborted: boolean;
   state: RequestTimeoutState;
};
