import { ApiParams } from '../request';

export enum AwacsApiActions {
   Groups = 'Groups',
   ListNamespaceSummaries = 'ListNamespaceSummaries',
   BalancersNamespacesListNonQuickStart = 'BalancersNamespacesListNonQuickStart',
   ListBackends = 'ListBackends',
   ListBalancers = 'ListBalancers',
   ListUpstreams = 'ListUpstreams',
   ListDnsRecords = 'ListDnsRecords',
   ListCertificates = 'ListCertificates',
   ListCertificateRenewals = 'ListCertificateRenewals',
   CreateBalancer = 'CreateBalancer',
   GetBalancersAspectSets = 'GetBalancersAspectSets',
   GetNamespace = 'GetNamespace',
   GetQuickStartBalancersUnion = 'GetQuickStartBalancersUnion',
   UpdateQuickStartBalancersUnion = 'UpdateQuickStartBalancersUnion',
   GetL3Balancers = 'GetL3Balancers',
   GetNamespaceAspectsSet = 'GetNamespaceAspectsSet',
}

interface KnownAwacsApiParams {
   [AwacsApiActions.ListBackends]: ApiParams<ListBackendsReq, ListBackendsRsp>;
   [AwacsApiActions.GetNamespaceAspectsSet]: ApiParams<GetNamespaceAspectsSetReq, GetNamespaceAspectsSetRsp>;
}

export type AwacsApiParams = KnownAwacsApiParams & Record<Exclude<AwacsApiActions, keyof KnownAwacsApiParams>, any>;

export interface EndpointSetRecord {
   id: string;
   cluster: string;
}

// region Backend

interface BackendMeta {
   namespaceId: string;
}

interface Backend {
   meta: BackendMeta;
}

export interface ListBackendsReq {
   query: {
      ypEndpointSetFullIdIn: EndpointSetRecord[];
   };
}

export interface ListBackendsRsp {
   backends: Backend[];
   annotatedBackends: Backend[];
   total: number;
}

export interface GetNamespaceAspectsSetReq {
   id: string;
}

export interface GetNamespaceAspectsSetRsp {
   aspectsSet: {
      content: {
         graph: {
            content: {
               inclusionGraphJson: string;
            };
         };
      };
   };
}

// endregion

// region Balancer

interface BalancerMeta {
   generation: string;
   auth: { staff: { owners: { groupIds: string[]; logins: string[] } }; type: string };
   namespaceId: string;
   author: string;
   ctime: string;
   transportPaused: { author: string; comment: string; mtime: string; value: boolean };
   comment: string;
   location: { ypCluster: string; type: string };
   id: string;
   category: string;
   mtime: string;
   version: string;
}

interface BalancerComponentRecord {
   state: string;
   version: string;
}

interface BalancerSpec {
   components: Record<string, BalancerComponentRecord>;
   incomplete: boolean;
   deleted: boolean;
   yandexBalancer: {
      mode: string;
      templateEngine: string;
      config: {
         quickStartBalancerMacro: {
            headers: any[];
            responseHeaders: any[];
            http: any;
            domains: {
               routes: {
                  id: string;
                  matcher: { pathPrefix: string };
                  endpointSets: { cluster: string; id: string }[];
               }[];
               httpsOnly: boolean;
               cert: string;
               id: string;
               httpOnly: boolean;
               matcher: { hosts: string[]; host: string };
            }[];
            https: any;
            version: string;
         };
         modules: any[];
      };
      yaml: string;
   };
   ctlVersion: number;
   type: string;
   configTransport: {
      nannyStaticFile: {
         snapshotPriority: string;
         gridfsUrl: string;
         instanceTags: { ctype: string; prj: string; itype: string };
         serviceId: string;
      };
      type: string;
   };
}

interface BalancerStatusItem {
   reason: string;
   meta?: { nannyStaticFile: { snapshots: any[] }; type: string };
   message: string;
   status: string;
}

interface BalancerStatusRevision {
   inProgress: BalancerStatusItem;
   validated: BalancerStatusItem;
   active: BalancerStatusItem;
   ctime: string;
   id: string;
}

interface BalancerStatus {
   inProgress: BalancerStatusItem;
   validated: BalancerStatusItem;
   active: BalancerStatusItem;
   revisions: BalancerStatusRevision[];
}

interface BalancerOrder {
   approval: { afterChangingAbcServiceId: boolean; afterAllocation: boolean };
   progress: {
      context: {
         endpoint_set_id: string;
         abc_role_staff_id: string;
         pod_set_id: string;
         created_nanny_service_id: string;
         pre_allocation_id: string;
         system_endpoint_set_id: string;
         pod_ids: string;
      };
      messages: any[];
      state: { enteredAt: string; id: string; attempts: number };
      errors: any[];
   };
   content: {
      mode: string;
      copySpecFromBalancerId: string;
      waitForApprovalAfterAllocation: boolean;
      activateBalancer: boolean;
      domainHosts: string[];
      doNotCreateUserEndpointSet: boolean;
      certId: string;
      secondaryCertId: string;
      allocationRequest: {
         location: string;
         virtualServiceIds: any[];
         nannyServiceIdSlug: string;
         preset: { instancesCount: number; type: string };
         type: string;
         networkMacro: string;
      };
      endpointSets: { cluster: string; id: string }[];
      abcServiceId: number;
   };
   status: { reason: string; message: string; lastTransitionTime: string; status: string };
}

interface Balancer {
   meta: BalancerMeta;
   spec: BalancerSpec;
   status: BalancerStatus;
   order: BalancerOrder;
}

export interface ListBalancersInput {
   query: {
      ypEndpointSetFullIdIn: EndpointSetRecord[];
   };
}

export interface ListBalancersPayload {
   balancers: Balancer[];
   total: number;
}

// endregion
