import { SimpleSubscription } from '@yandex-data-ui/infra-buzzer';
import { BYTES, IEnumOption, TIMES_IN_MS } from '@yandex-infracloud-ui/libs';

import { defaultOS } from '../old-code/store/reducers/sandbox';
import { getHexRef } from '../utils';

// noinspection SpellCheckingInspection
// список слоев нужно держать в одном месте, чтобы не обновлять их в трех местах!
export const DEFAULT_OS_LIST: IEnumOption[] = defaultOS;

export const DefaultOS = DEFAULT_OS_LIST.find(r => r.title === 'xenial-app')!.value;

export const EMPTY_CHECKSUM = 'EMPTY:';

export const DEFAULT_TVM_CLIENT_PORT = 2;

export const DEFAULT_JUGGLER_PORT = 31579;

export const DEFAULT_DISK_ID = 'main-disk';

export const DEFAULT_LAYER_ID = 'layer';
export const DEFAULT_LAYER_REF = getHexRef();

export const SIMPLE_HTTP_SERVER_LAYER_ID = 'simple_http_server';
export const SIMPLE_HTTP_SERVER_LAYER_URL = 'sbr:755375039';
export const SIMPLE_HTTP_SERVER_LAYER_REF = getHexRef();

export const DEFAULT_CLUSTERS = new Set(['sas', 'man', 'vla']);

export const DEFAULT_DISK_SIZE = 3 * BYTES.GB;

export const DEFAULT_HDD_BANDWIDTH_GUARANTEE = 15 * BYTES.MB;

export const HDD_BANDWIDTH_LIMIT_FACTOR = 2;

export const DEFAULT_SSD_BANDWIDTH_GUARANTEE = 30 * BYTES.MB;

export const SSD_BANDWIDTH_LIMIT_FACTOR = 1;

export const DEFAULT_NETWORK_BANDWIDTH_GUARANTEE = 10 * BYTES.MB;

export const FORMS_STORE_VERSION = 7; // please increment, if format was changed

export const HUGE_FORM_STORE_VERSION = 7; // please increment, if format was changed

export const YANDEX_DOCKER_REGISTRY_HOST = 'registry.yandex.net';

export const YANDEX_DOCKER_REGISTRY = `https://${YANDEX_DOCKER_REGISTRY_HOST}/`;

export const DEFAULT_STATIC_RESOURCE_CHECK_PERIOD = 3 * TIMES_IN_MS.Minute;

export const STAGE_LOG_DEFAULT_PERIOD_IN_HOURS = 3;

export const BUZZER_SERVICES: SimpleSubscription[] = [
   // Deploy
   { serviceId: 687, environmentId: 989 },
   // Awacs
   { serviceId: 337, environmentId: 525 },
   // YP Production
   { serviceId: 6, environmentId: 13 },
   // YP XDC
   { serviceId: 6, environmentId: 549 },
   // Stage Controller
   { serviceId: 396, environmentId: 624 },
   // Docker registry
   { serviceId: 355, environmentId: 566 },
];

export const LONG_REQUEST_PERIOD = 15 * TIMES_IN_MS.Second;

export const DEFAULT_REQUEST_TIMEOUT = 1 * TIMES_IN_MS.Minute;

export const DEFAULT_PORT_FOR_DEFAULT_ENDPOINT_SET = 80;
export const DEFAULT_PROTOCOL_FOR_DEFAULT_ENDPOINT_SET = 'tcp';
export const DEFAULT_LIVENESS_LIMIT_RATIO_FOR_DEFAULT_ENDPOINT_SET = 0.35;

export const NEW_SECRET_STORAGE_BY_DEFAULT = true;
