// format-off
// prettier-ignore
export type DeepPartial<T> = {
   [P in keyof T]?:
      T[P] extends Array<infer U> ? Array<DeepPartial<U>> :
      T[P] extends ReadonlyArray<infer U> ? ReadonlyArray<DeepPartial<U>> :
      T[P] extends Date | Function | Uint8Array | undefined ? T[P] :
      T[P] extends infer U | undefined ? DeepPartial<U> :
      T[P] extends object ? DeepPartial<T[P]> :
      T[P];
};
// format-on

// format-off
// prettier-ignore
export type DeepReadonly<T> =
   T extends [infer X, ...infer Y] ? readonly [DeepReadonly<X>, ...DeepReadonly<Y>] :
   T extends Array<infer X> ? ReadonlyArray<DeepReadonly<X>> :
   T extends ReadonlyArray<infer X> ? ReadonlyArray<DeepReadonly<X>> :
   T extends Set<infer X> ? ReadonlySet<DeepReadonly<X>> :
   T extends ReadonlySet<infer X> ? ReadonlySet<DeepReadonly<X>> :
   T extends Map<infer X, infer Y> ? ReadonlyMap<DeepReadonly<X>, DeepReadonly<Y>> :
   T extends ReadonlyMap<infer X, infer Y> ? ReadonlyMap<DeepReadonly<X>, DeepReadonly<Y>> :
   T extends object ? {+readonly [P in keyof T]: DeepReadonly<T[P]>} :
   T;
// format-on

export type PropType<TObj, TProp extends keyof TObj> = TObj[TProp];

export type PickByFieldType<FromType, KeepType, Include = true> = {
   [K in keyof FromType]: FromType[K] extends KeepType
      ? Include extends true
         ? K
         : never
      : Include extends true
      ? never
      : K;
};

export type GetFieldsByType<FromType, KeepType, Include = true> = PickByFieldType<
   FromType,
   KeepType,
   Include
>[keyof FromType];

export type Nullable<T> = {
   [P in keyof T]: T[P] | null;
};
