import { ReactNode } from 'react';

export interface Confirmation {
   id: ConfirmationType;
   title: string;
   description: ReactNode;
}

export type StageConfirmations = {
   [duId: string]: Set<ConfirmationType>;
};

export enum ConfirmationType {
   SecretsMigration = 'secretsMigration',
   SsdBandwidth = 'ssdBandwidth',
   HddBandwidth = 'hddBandwidth',
   DiskIsolation = 'diskIsolation',
   LogbrokerUpdate = 'logbrokerUpdate',
   PodAgentUpdate = 'podAgentUpdate',
   PodLayerUpdate = 'podLayerUpdate',
   TvmAgentUpdate = 'tvmAgentUpdate',
   DruAgentUpdate = 'druAgentUpdate',
   NetworkBandwidthUpdate = 'networkBandwidthUpdate',
   PatchersRevisionUpdate = 'patchersRevisionUpdate',
}
