import { createKey } from '../../../utils';

const namespace = 'approval-policy';

export enum ApprovalPolicyRequestKeysActions {
   FETCH = 'fetch',
   FETCH_MANY = 'fetchMany',
   DELETE = 'delete',
   CREATE = 'create',
   UPDATE = 'update',
}

export const approvalPolicyActionsArray = Object.values(ApprovalPolicyRequestKeysActions);

export const ApprovalPolicyRequestKeys = {
   getOne: ({ stageId, action }: { stageId: string; action: ApprovalPolicyRequestKeysActions }) =>
      `${namespace}-${createKey({ type: 'getOne', stageId, action })}`,
};
