import { TRspSelectObjectHistory_TEvent } from '../../../proto-typings';

export type HistoryEvent = Partial<Omit<TRspSelectObjectHistory_TEvent, 'results'>> & {
   result: any; // TODO: автоматически выводить тип в зависимости от objectType
};

export function getHistoryEventTime(historyEvent: HistoryEvent): { seconds: number; nanos: number } {
   const { seconds, nanos } = historyEvent.time as { seconds: number; nanos: number };

   return { seconds, nanos };
}

export function getHistoryEventId(historyEvent: HistoryEvent): string {
   const { seconds, nanos } = getHistoryEventTime(historyEvent);

   return `${seconds}-${nanos}`;
}

export const getHistoryEventTimestamp = (historyEvent: HistoryEvent) => {
   const { seconds, nanos } = getHistoryEventTime(historyEvent);

   return seconds * 1000 + nanos / 1000000;
};
