export enum QuotaSegment {
   Dev = 'dev',
   Default = 'default',
}

export const QuotaSegmentSet: Set<string> = new Set([QuotaSegment.Default, QuotaSegment.Dev]);

export enum QuotaMetric {
   Total = 'total',
   Usage = 'usage',
}

export interface QuotaKeyParams {
   abc: string; // id ABC сервиса
   location: string; // локация
   segment: string; // QuotaSegment или другие сегменты
   resourceGroup: string;
   resource: string;
   metric: QuotaMetric;
}

export const defaultQuotaOrder = ['abc', 'location', 'segment', 'resourceGroup', 'resource', 'metric'] as const;

// плоская модель ресурсов
/**
 * quotaKey === createKey({location, resourceGroup, resource})
 */
export type QuotaResourcesStore = {
   [quotaKey: string]: number;
};
