import { TDeployTicket } from '../../../../proto-typings';
import { DeployTicketConverter } from './DeployTicket';

const rawTickets: TDeployTicket[] = [
   {
      labels: {},
      status: {
         progress: {
            closed: {
               status: 'true',
               reason: 'CLOSED',
               message: 'All patches are closed',
               last_transition_time: { seconds: 1592398490, nanos: 603795000 },
            },
            start_time: { seconds: 1592398353, nanos: 571603000 },
            end_time: { seconds: 1592398490, nanos: 603795000 },
         },
         action: { type: 'commit', reason: 'ManualCommit', message: 'TODO docker description' },
         patches: {
            'patch-frontend': {
               progress: {
                  success: {
                     status: 'true',
                     reason: 'SUCCESS',
                     message: 'Patch deployed successfully',
                     last_transition_time: { seconds: 1592398490, nanos: 603728000 },
                  },
                  start_time: { seconds: 1592398353, nanos: 571534000 },
                  end_time: { seconds: 1592398490, nanos: 603728000 },
               },
               action: {
                  type: 'commit',
                  reason: 'ManualCommit',
                  message: 'Deploy ticket was committed: TODO docker description',
               },
               stage_spec_timestamp: 1709824663766433861,
            },
         },
      },
      spec: {
         release_id: 'DOCKER-stable-metrika-cms-frontend:702739201.6979012',
         release_rule_id: '',
         patches: {
            'patch-frontend': {
               docker: {
                  docker_image_ref: {
                     deploy_unit_id: 'frontend',
                     box_id: 'frontend',
                  },
               },
            },
         },
         title:
            'Created from release DOCKER-stable-metrika-cms-frontend:702739201.6979012 and release rule cms-production-frontend',
         description:
            'Created from release DOCKER-stable-metrika-cms-frontend:702739201.6979012 and release rule cms-production-frontend',
      },
      meta: {
         stage_id: 'cms-production',
         inherit_acl: true,
         type: 'deploy_ticket',
         acl: [
            {
               action: 'allow',
               permissions: ['read', 'write', 'create', 'ssh_access', 'root_ssh_access', 'read_secrets'],
               subjects: ['konkov', 'robot-drug-deploy', 'abc:service:185'],
            },
            {
               action: 'allow',
               permissions: ['read', 'write', 'create'],
               subjects: ['deploy:cms-production.cms-production.MAINTAINER'],
               attributes: ['', '/spec', '/labels', '/annotations'],
            },
            {
               action: 'allow',
               permissions: ['ssh_access', 'root_ssh_access'],
               subjects: ['deploy:cms-production.cms-production.MAINTAINER'],
               attributes: ['/access/deploy/box/default'],
            },
            {
               action: 'allow',
               permissions: ['read', 'write', 'create', 'use'],
               subjects: ['deploy:cms-production.OWNER'],
               attributes: ['', '/spec', '/labels', '/annotations'],
            },
            {
               action: 'allow',
               permissions: ['ssh_access', 'root_ssh_access'],
               subjects: ['deploy:cms-production.OWNER'],
               attributes: ['/access/deploy/box/default'],
            },
         ],
         creation_time: 1592397219007411,
         id: 'DOCKER-stable-metrika-cms-frontend:702739201.6979012-cms-production-frontend',
         uuid: '168a500c-bd737221-9e4dff97-307c8475',
      },
      annotations: {},
   },
   {
      labels: {},
      status: {
         progress: {
            closed: {
               status: 'true',
               reason: 'CLOSED',
               message: 'All patches are closed',
               last_transition_time: { seconds: 1592398098, nanos: 520718000 },
            },
            start_time: { seconds: 1592397958, nanos: 897970000 },
            end_time: { seconds: 1592398098, nanos: 520718000 },
         },
         action: { type: 'commit', reason: 'ManualCommit', message: 'TODO docker description' },
         patches: {
            'patch-judge': {
               progress: {
                  success: {
                     status: 'true',
                     reason: 'SUCCESS',
                     message: 'Patch deployed successfully',
                     last_transition_time: { seconds: 1592398098, nanos: 520633000 },
                  },
                  start_time: { seconds: 1592397958, nanos: 897903000 },
                  end_time: { seconds: 1592398098, nanos: 520633000 },
               },
               action: {
                  type: 'commit',
                  reason: 'ManualCommit',
                  message: 'Deploy ticket was committed: TODO docker description',
               },
               stage_spec_timestamp: 1709824249302089816,
            },
         },
      },
      spec: {
         release_id: 'DOCKER-stable-metrika-cms-judge:702739330.6979012',
         release_rule_id: '',
         patches: {
            'patch-judge': {
               docker: {
                  docker_image_ref: {
                     deploy_unit_id: 'judge',
                     box_id: 'judge',
                  },
               },
            },
         },
         title:
            'Created from release DOCKER-stable-metrika-cms-judge:702739330.6979012 and release rule cms-production-judge',
         description:
            'Created from release DOCKER-stable-metrika-cms-judge:702739330.6979012 and release rule cms-production-judge',
      },
      meta: {
         stage_id: 'cms-production',
         inherit_acl: true,
         type: 'deploy_ticket',
         acl: [
            {
               action: 'allow',
               permissions: ['read', 'write', 'create', 'ssh_access', 'root_ssh_access', 'read_secrets'],
               subjects: ['konkov', 'robot-drug-deploy', 'abc:service:185'],
            },
            {
               action: 'allow',
               permissions: ['read', 'write', 'create'],
               subjects: ['deploy:cms-production.cms-production.MAINTAINER'],
               attributes: ['', '/spec', '/labels', '/annotations'],
            },
            {
               action: 'allow',
               permissions: ['ssh_access', 'root_ssh_access'],
               subjects: ['deploy:cms-production.cms-production.MAINTAINER'],
               attributes: ['/access/deploy/box/default'],
            },
            {
               action: 'allow',
               permissions: ['read', 'write', 'create', 'use'],
               subjects: ['deploy:cms-production.OWNER'],
               attributes: ['', '/spec', '/labels', '/annotations'],
            },
            {
               action: 'allow',
               permissions: ['ssh_access', 'root_ssh_access'],
               subjects: ['deploy:cms-production.OWNER'],
               attributes: ['/access/deploy/box/default'],
            },
         ],
         creation_time: 1592397220999902,
         id: 'DOCKER-stable-metrika-cms-judge:702739330.6979012-cms-production-judge',
         uuid: '45c65836-f9e0b9c0-7de7623d-97fde03c',
      },
      annotations: {},
   },
   {
      labels: {},
      status: {
         progress: {
            closed: {
               status: 'true',
               reason: 'CLOSED',
               message: 'All patches are closed',
               last_transition_time: { seconds: 1592398326, nanos: 684385000 },
            },
            start_time: { seconds: 1592398159, nanos: 662553000 },
            end_time: { seconds: 1592398326, nanos: 684385000 },
         },
         action: { type: 'commit', reason: 'ManualCommit', message: 'TODO docker description' },
         patches: {
            'patch-marshal': {
               progress: {
                  success: {
                     status: 'true',
                     reason: 'SUCCESS',
                     message: 'Patch deployed successfully',
                     last_transition_time: { seconds: 1592398326, nanos: 684322000 },
                  },
                  start_time: { seconds: 1592398159, nanos: 662488000 },
                  end_time: { seconds: 1592398326, nanos: 684322000 },
               },
               action: {
                  type: 'commit',
                  reason: 'ManualCommit',
                  message: 'Deploy ticket was committed: TODO docker description',
               },
               stage_spec_timestamp: 1709824467271680059,
            },
         },
      },
      spec: {
         release_id: 'DOCKER-stable-metrika-cms-marshal:702739237.6979012',
         release_rule_id: '',
         patches: {
            'patch-marshal': {
               docker: {
                  docker_image_ref: {
                     deploy_unit_id: 'marshal',
                     box_id: 'marshal',
                  },
               },
            },
         },
         title:
            'Created from release DOCKER-stable-metrika-cms-marshal:702739237.6979012 and release rule cms-production-marshal',
         description:
            'Created from release DOCKER-stable-metrika-cms-marshal:702739237.6979012 and release rule cms-production-marshal',
      },
      meta: {
         stage_id: 'cms-production',
         inherit_acl: true,
         type: 'deploy_ticket',
         acl: [
            {
               action: 'allow',
               permissions: ['read', 'write', 'create', 'ssh_access', 'root_ssh_access', 'read_secrets'],
               subjects: ['konkov', 'robot-drug-deploy', 'abc:service:185'],
            },
            {
               action: 'allow',
               permissions: ['read', 'write', 'create'],
               subjects: ['deploy:cms-production.cms-production.MAINTAINER'],
               attributes: ['', '/spec', '/labels', '/annotations'],
            },
            {
               action: 'allow',
               permissions: ['ssh_access', 'root_ssh_access'],
               subjects: ['deploy:cms-production.cms-production.MAINTAINER'],
               attributes: ['/access/deploy/box/default'],
            },
            {
               action: 'allow',
               permissions: ['read', 'write', 'create', 'use'],
               subjects: ['deploy:cms-production.OWNER'],
               attributes: ['', '/spec', '/labels', '/annotations'],
            },
            {
               action: 'allow',
               permissions: ['ssh_access', 'root_ssh_access'],
               subjects: ['deploy:cms-production.OWNER'],
               attributes: ['/access/deploy/box/default'],
            },
         ],
         creation_time: 1592397211341425,
         id: 'DOCKER-stable-metrika-cms-marshal:702739237.6979012-cms-production-marshal',
         uuid: '4afdc51c-ed946741-df973e87-e20f6aa6',
      },
      annotations: {},
   },
   {
      labels: {},
      status: {
         progress: {
            closed: {
               status: 'true',
               reason: 'CLOSED',
               message: 'All patches are closed',
               last_transition_time: { seconds: 1592475678, nanos: 279466000 },
            },
            start_time: { seconds: 1592475538, nanos: 698259000 },
            end_time: { seconds: 1592475678, nanos: 279466000 },
         },
         action: {
            type: 'commit',
            reason: 'AUTOCOMMIT',
            message: 'Ticket applied due to autocommit policy.',
         },
         patches: {
            'patch-judge': {
               progress: {
                  success: {
                     status: 'true',
                     reason: 'SUCCESS',
                     message: 'Patch deployed successfully',
                     last_transition_time: { seconds: 1592475678, nanos: 279358000 },
                  },
                  start_time: { seconds: 1592475538, nanos: 698136000 },
                  end_time: { seconds: 1592475678, nanos: 279358000 },
               },
               action: {
                  type: 'commit',
                  reason: 'AUTOCOMMIT',
                  message: 'Deploy ticket was committed: Ticket applied due to autocommit policy.',
               },
               stage_spec_timestamp: 1709907541602861218,
            },
            'patch-frontend': {
               progress: {
                  success: {
                     status: 'true',
                     reason: 'SUCCESS',
                     message: 'Patch deployed successfully',
                     last_transition_time: { seconds: 1592475678, nanos: 279421000 },
                  },
                  start_time: { seconds: 1592475538, nanos: 698227000 },
                  end_time: { seconds: 1592475678, nanos: 279421000 },
               },
               action: {
                  type: 'commit',
                  reason: 'AUTOCOMMIT',
                  message: 'Deploy ticket was committed: Ticket applied due to autocommit policy.',
               },
               stage_spec_timestamp: 1709907541602861218,
            },
            'patch-marshal': {
               progress: {
                  success: {
                     status: 'true',
                     reason: 'SUCCESS',
                     message: 'Patch deployed successfully',
                     last_transition_time: { seconds: 1592475678, nanos: 279278000 },
                  },
                  start_time: { seconds: 1592475538, nanos: 698027000 },
                  end_time: { seconds: 1592475678, nanos: 279278000 },
               },
               action: {
                  type: 'commit',
                  reason: 'AUTOCOMMIT',
                  message: 'Deploy ticket was committed: Ticket applied due to autocommit policy.',
               },
               stage_spec_timestamp: 1709907541602861218,
            },
         },
      },
      spec: {
         release_id: 'SANDBOX-703536913-stable',
         release_rule_id: 'cms-production-rule',
         patches: {
            'patch-marshal': {
               sandbox: {
                  sandbox_resource_type: 'METRIKA_CMS_MARSHAL',
                  static: { deploy_unit_id: 'marshal', layer_ref: 'marshal' },
               },
            },
            'patch-judge': {
               sandbox: {
                  sandbox_resource_type: 'METRIKA_CMS_JUDGE',
                  static: { deploy_unit_id: 'judge', layer_ref: 'judge' },
               },
            },
            'patch-frontend': {
               sandbox: {
                  sandbox_resource_type: 'METRIKA_CMS_FRONTEND',
                  static: { deploy_unit_id: 'frontend', layer_ref: 'frontend' },
               },
            },
         },
         title: 'Created from release SANDBOX-703536913-stable and release rule cms-production-rule',
         description: 'Created from release SANDBOX-703536913-stable and release rule cms-production-rule',
      },
      meta: {
         stage_id: 'cms-production',
         inherit_acl: true,
         type: 'deploy_ticket',
         acl: [
            {
               action: 'allow',
               permissions: ['read', 'write', 'create', 'ssh_access', 'root_ssh_access', 'read_secrets'],
               subjects: ['konkov', 'robot-drug-deploy', 'abc:service:185'],
            },
            {
               action: 'allow',
               permissions: ['read', 'write', 'create'],
               subjects: ['deploy:cms-production.cms-production.MAINTAINER'],
               attributes: ['', '/spec', '/labels', '/annotations'],
            },
            {
               action: 'allow',
               permissions: ['ssh_access', 'root_ssh_access'],
               subjects: ['deploy:cms-production.cms-production.MAINTAINER'],
               attributes: ['/access/deploy/box/default'],
            },
            {
               action: 'allow',
               permissions: ['read', 'write', 'create', 'use'],
               subjects: ['deploy:cms.OWNER'],
               attributes: ['', '/spec', '/labels', '/annotations'],
            },
            {
               action: 'allow',
               permissions: ['ssh_access', 'root_ssh_access'],
               subjects: ['deploy:cms.OWNER'],
               attributes: ['/access/deploy/box/default'],
            },
         ],
         creation_time: 1592475491506659,
         id: 'SANDBOX-703536913-stable-cms-production-rule',
         uuid: '4f8feffa-61940f96-845adcc9-7b001746',
      },
      annotations: {},
   },
   {
      labels: {},
      status: { patches: { 'patch-marshal': {}, 'patch-judge': {}, 'patch-frontend': {} } },
      spec: {
         release_id: 'SANDBOX-717997947-stable',
         release_rule_id: 'cms-production-rule',
         patches: {
            'patch-marshal': { docker: {} },
            'patch-judge': { docker: {} },
            'patch-frontend': { docker: {} },
         },
         title: 'Created from release SANDBOX-717997947-stable and release rule cms-production-rule',
         description: 'Created from release SANDBOX-717997947-stable and release rule cms-production-rule',
      },
      meta: {
         stage_id: 'cms-production',
         inherit_acl: true,
         type: 'deploy_ticket',
         acl: [
            {
               action: 'allow',
               permissions: ['read', 'write', 'create', 'ssh_access', 'root_ssh_access', 'read_secrets'],
               subjects: ['konkov', 'robot-drug-deploy', 'abc:service:185'],
            },
            {
               action: 'allow',
               permissions: ['read', 'write', 'create'],
               subjects: ['deploy:cms-production.cms-production.MAINTAINER'],
               attributes: ['', '/spec', '/labels', '/annotations'],
            },
            {
               action: 'allow',
               permissions: ['ssh_access', 'root_ssh_access'],
               subjects: ['deploy:cms-production.cms-production.MAINTAINER'],
               attributes: ['/access/deploy/box/default'],
            },
            {
               action: 'allow',
               permissions: ['read', 'write', 'create', 'use'],
               subjects: ['deploy:metrika-infra.OWNER'],
               attributes: ['', '/spec', '/labels', '/annotations'],
            },
            {
               action: 'allow',
               permissions: ['ssh_access', 'root_ssh_access'],
               subjects: ['deploy:metrika-infra.OWNER'],
               attributes: ['/access/deploy/box/default'],
            },
         ],
         creation_time: 1594111011532464,
         id: 'SANDBOX-717997947-stable-cms-production-rule',
         uuid: '35aa9269-7b3a4765-93114f1d-a6ff7e39',
      },
      annotations: {},
   },
] as any;

describe('models/ui|DeployTicket', () => {
   it('should not throw error', () => {
      expect(() => rawTickets.map(DeployTicketConverter.fromApi)).not.toThrow();
   });
});
