import { TDeployTicketSpec_EDeployTicketSourceType } from '../../../../proto-typings';
import { createKey } from '../../../../utils';
import { DeployTicket } from './DeployTicket';

function getReleaseIds(tickets: DeployTicket[]): Set<string> {
   const releaseIds = new Set<string>();
   for (const ticket of tickets) {
      if (ticket.sourceType === TDeployTicketSpec_EDeployTicketSourceType.RELEASE_INTEGRATION && ticket.releaseId) {
         releaseIds.add(ticket.releaseId);
      }
   }
   return releaseIds;
}

function getStageIds(tickets: DeployTicket[]): Set<string> {
   const stageIds = new Set<string>();
   for (const ticket of tickets) {
      if (ticket.stageId) {
         stageIds.add(ticket.stageId);
      }
   }
   return stageIds;
}

/**
 * @returns `Map<createKey({stageId, login})>`
 */
function getApprovalStageLogins(tickets: DeployTicket[], userLogins?: string[]): Set<string> {
   const store = new Set<string>();
   for (const ticket of tickets) {
      const { approval, stageId } = ticket;
      for (const login of [...approval.data.keys(), ...(userLogins ?? [])]) {
         const key = createKey({ stageId, login });
         if (!store.has(key)) {
            store.add(key);
         }
      }
   }
   return store;
}

export const DeployTicketAggregation = {
   getReleaseIds,
   getStageIds,
   getApprovalStageLogins,
};
