export enum TicketStatus {
   // Action statuses

   /**
    * !!!НЕ выставляется заранее!!!, подставляется после получения информации о ApprovalPolicy, если для тикета требуется одобрение
    */
   WaitingForApprove = 'waitingForApprove',
   /**
    * Если action отсутсвует, то считается, что он None
    */
   WaitingForCommit = 'waitingForCommit',

   /**
    * Тикет не будет закоммичен, пропуск
    */
   Skip = 'skip',

   /**
    * Тикет встал в очередь на Commit (перед ним есть еще тикеты в процессе)
    */
   Wait = 'wait',

   /**
    * Факап, релизы поставлены на паузу, релизные правила не работают
    */
   OnHold = 'onHold',

   /**
    * Тикет закоммители, но у него еще не появилось поле `progress`
    */
   Committed = 'committed',

   // Progress statuses
   Pending = 'pending',
   InProgress = 'inProgress',
   Success = 'success',
   Failed = 'failed',
   Cancelled = 'cancelled',
   Closed = 'closed',

   Unknown = 'unknown', // Fallback
}

export const MutableTicketStatuses = new Set([TicketStatus.WaitingForCommit, TicketStatus.Wait, TicketStatus.OnHold]);

export const ProcessingTicketStatuses = new Set([
   TicketStatus.Committed,
   TicketStatus.Pending,
   TicketStatus.InProgress,
]);

/**
 * Статусы, возможные только для тикетов
 *
 * (исключая статусы, применимые только к патчам)
 */
export const OnlyTicketStatuses = new Set([
   TicketStatus.WaitingForCommit,
   TicketStatus.WaitingForApprove,
   TicketStatus.Committed,
   TicketStatus.Pending,
   TicketStatus.InProgress,
   TicketStatus.Closed,
   TicketStatus.OnHold,
   TicketStatus.Skip,
   TicketStatus.Wait,
   TicketStatus.Unknown,
]);

export const ActiveTicketStatuses = [
   TicketStatus.WaitingForCommit,
   TicketStatus.WaitingForApprove,
   TicketStatus.Pending,
   TicketStatus.InProgress,
   TicketStatus.Committed,
   TicketStatus.OnHold,
   TicketStatus.Wait,
];

export const HistoryTicketStatuses = [TicketStatus.Closed, TicketStatus.Skip, TicketStatus.Unknown];

export const TICKET_STATUS_NAMES = {
   [TicketStatus.WaitingForApprove]: 'Waiting for approve',
   [TicketStatus.WaitingForCommit]: 'Waiting for commit',
   [TicketStatus.Skip]: 'Skip',
   [TicketStatus.Wait]: 'Wait',
   [TicketStatus.OnHold]: 'On hold',
   [TicketStatus.Committed]: 'Committed',
   [TicketStatus.Pending]: 'Pending',
   [TicketStatus.InProgress]: 'In progress',
   [TicketStatus.Success]: 'Success',
   [TicketStatus.Failed]: 'Failed',
   [TicketStatus.Cancelled]: 'Cancelled',
   [TicketStatus.Closed]: 'Closed',
   [TicketStatus.Unknown]: 'Unknown',
};
