export enum ReleaseObjectStatus {
   // начальный статус
   Created,

   // после матчинга с релизными правилами и создания деплойных тикетов
   Open,

   // Progress statuses
   Pending = 'pending',
   InProgress = 'inProgress',

   // когда все тикеты закрыты
   Closed = 'closed',

   Unknown = 'unknown', // Fallback
}

export const RELEASE_STATUS_NAMES: Record<ReleaseObjectStatus, string> = {
   [ReleaseObjectStatus.Created]: 'Created',
   [ReleaseObjectStatus.Open]: 'Open',
   [ReleaseObjectStatus.Pending]: 'Pending',
   [ReleaseObjectStatus.InProgress]: 'In progress',
   [ReleaseObjectStatus.Closed]: 'Closed',
   [ReleaseObjectStatus.Unknown]: 'Unknown',
};
