import { TReleaseRule } from '../../../../proto-typings';
import { ReleaseRuleConverter } from './ReleaseRule';

const rawRule: TReleaseRule = {
   labels: {},
   status: {},
   spec: {
      auto_commit_policy: {},
      patches: {
         'patch-judge': {
            sandbox: {
               sandbox_resource_type: 'METRIKA_CMS_JUDGE',
               static: { deploy_unit_id: 'judge', layer_ref: 'judge' },
            },
         },
         'patch-frontend': {
            sandbox: {
               sandbox_resource_type: 'METRIKA_CMS_FRONTEND',
               static: { deploy_unit_id: 'frontend', layer_ref: 'frontend' },
            },
         },
         'patch-marshal': {
            sandbox: {
               sandbox_resource_type: 'METRIKA_CMS_MARSHAL',
               static: { deploy_unit_id: 'marshal', layer_ref: 'marshal' },
            },
         },
      },
      sandbox: {
         task_type: 'YA_PACKAGE',
         resource_types: ['METRIKA_CMS_FRONTEND', 'METRIKA_CMS_JUDGE', 'METRIKA_CMS_MARSHAL'],
         release_types: ['stable'],
      },
   },
   meta: {
      stage_id: 'cms-production',
      inherit_acl: true,
      type: 'release_rule',
      acl: [
         {
            action: 'allow',
            permissions: ['read', 'write'],
            subjects: ['konkov'],
         },
         {
            action: 'allow',
            permissions: ['read', 'write', 'create', 'ssh_access', 'root_ssh_access', 'read_secrets'],
            subjects: ['konkov'],
         },
      ],
      creation_time: 1592474197743396,
      id: 'cms-production-rule',
      uuid: '1f23c520-491171de-c3de99c1-660d2e17',
   },
   annotations: {},
} as any;

describe('models/ui|ReleaseRule', () => {
   it('should not throw error', () => {
      expect(() => ReleaseRuleConverter.fromApi(rawRule)).not.toThrow();
   });
});
