import { IJsonable } from '@yandex-infracloud-ui/libs';

import { TReleaseRule } from '../../../../proto-typings';
import { Entity } from '../../../../redux/models';

import { ReleaseRuleFormParams, ReleaseRuleFormParamsConverter, ReleaseRuleType } from './ReleaseRuleFormParams';

export interface ReleaseRule {
   autocommit: boolean;
   creationDate: number;
   description: string;
   form?: ReleaseRuleFormParams;
   id: string;
   patchCount: number;
   stageId: string;
   type: ReleaseRuleType;
}

export class ReleaseRuleConverter implements Entity, ReleaseRule, IJsonable {
   public static fromApi(raw: TReleaseRule): ReleaseRule {
      return new ReleaseRuleConverter(raw).toJSON();
   }

   public readonly autocommit: boolean;

   public readonly creationDate: number;

   public readonly description: string;

   public readonly form: ReleaseRuleFormParams;

   public readonly id: string;

   public patchCount: number;

   public readonly stageId: string;

   public readonly type: ReleaseRuleType;

   constructor(public raw: TReleaseRule) {
      this.creationDate = this.raw.meta!.creation_time / 1000;
      this.id = this.raw.meta!.id!;
      this.patchCount = Object.keys(this.raw.spec?.patches ?? {}).length;
      this.stageId = this.raw.meta!.stage_id;

      this.form = ReleaseRuleFormParamsConverter.fromApi(raw);
      this.autocommit = this.form.autocommit;
      this.type = this.form.type;
      this.description = this.form.description;
   }

   public toJSON(): ReleaseRule {
      return {
         autocommit: this.autocommit,
         creationDate: this.creationDate,
         description: this.description,
         form: this.form,
         id: this.id,
         patchCount: this.patchCount,
         stageId: this.stageId,
         type: this.type,
      };
   }
}
