import { EObjectType, TAutoCommitPolicy_EType, TReleaseRule } from '../../../../proto-typings';
import { DeepPartial } from '../../../typeHelpers';
import { ResourceType } from '../../stage/DeployUnit';
import {
   DockerFormParams,
   ReleaseRuleFormParams,
   ReleaseRuleFormParamsConverter,
   ReleaseRuleType,
   ReleaseType,
   SandboxFormParams,
} from './ReleaseRuleFormParams';

describe('models|ui/ReleaseRuleFormParams', () => {
   it('should convert sandbox rule', () => {
      const raw: DeepPartial<TReleaseRule> = {
         labels: {},
         status: {},
         spec: {
            auto_commit_policy: {
               type: TAutoCommitPolicy_EType.MAINTAIN_ACTIVE_TRUNK,
            },
            patches: {
               'patch-my-static': {
                  sandbox: {
                     sandbox_resource_type: 'SAMPLE_RELEASE_INTEGRATION_STATIC',
                     static: {
                        deploy_unit_id: 'DeployUnit1',
                        static_resource_ref: 'my-static',
                     },
                  },
               },
            },
            sandbox: {
               attributes: { key1: 'value1', key2: 'value2' },
               task_type: 'SAMPLE_RELEASE_TO_YA_DEPLOY_2',
               resource_types: ['SAMPLE_RELEASE_INTEGRATION_STATIC'],
               release_types: [ReleaseType.Testing],
            },
         },
         meta: {
            stage_id: 'test-release-integration-stage',
            inherit_acl: true,
            type: EObjectType.OT_RELEASE_RULE,
            creation_time: 1585213777182938,
            id: 'test-adding-to-begging',
            uuid: 'f5b60e-b56e38b3-f4354703-2a25ba37',
         },
         annotations: {},
      };

      const form = ReleaseRuleFormParamsConverter.fromApi(raw as TReleaseRule);

      expect(form).toEqual({
         id: 'test-adding-to-begging',
         releaseTypes: [ReleaseType.Testing],
         autocommit: true,
         description: '',
         type: ReleaseRuleType.Sandbox,
         sandbox: {
            attributes: [
               { key: 'key1', value: 'value1' },
               { key: 'key2', value: 'value2' },
            ],
            taskType: 'SAMPLE_RELEASE_TO_YA_DEPLOY_2',
            resources: ['SAMPLE_RELEASE_INTEGRATION_STATIC'],
            patches: [
               {
                  id: 'patch-my-static',
                  type: ResourceType.StaticResource,
                  resourceType: 'SAMPLE_RELEASE_INTEGRATION_STATIC',
                  deployUnitId: 'DeployUnit1',
                  ref: 'my-static',
               },
            ],
         } as SandboxFormParams,
         docker: undefined,
      } as ReleaseRuleFormParams);
   });

   it('should convert docker rule', () => {
      const raw: DeepPartial<TReleaseRule> = {
         labels: {},
         status: {},
         spec: {
            auto_commit_policy: {
               type: TAutoCommitPolicy_EType.MAINTAIN_ACTIVE_TRUNK,
            },
            patches: {
               'patch-my-static': {
                  docker: {
                     docker_image_ref: {
                        deploy_unit_id: 'DeployUnit1',
                        box_id: 'Box1',
                     },
                  },
               },
            },
            docker: {
               image_name: 'my_super_image',
               release_types: [ReleaseType.Testing],
            },
         },
         meta: {
            stage_id: 'test-release-integration-stage',
            inherit_acl: true,
            type: EObjectType.OT_RELEASE_RULE,
            creation_time: 1585213777182938,
            id: 'test-adding-to-begging',
            uuid: 'f5b60e-b56e38b3-f4354703-2a25ba37',
         },
         annotations: {},
      };

      const form = ReleaseRuleFormParamsConverter.fromApi(raw as TReleaseRule);

      expect(form).toEqual({
         id: 'test-adding-to-begging',
         releaseTypes: [ReleaseType.Testing],
         autocommit: true,
         description: '',
         type: ReleaseRuleType.Docker,
         docker: {
            image: 'my_super_image',
            patches: [
               {
                  boxId: 'Box1',
                  deployUnitId: 'DeployUnit1',
                  id: 'patch-my-static',
               },
            ],
         } as DockerFormParams,
      } as ReleaseRuleFormParams);
   });
});
