import { TBoxStatus } from '../../../../proto-typings';
import { getBoxWarning, getContainerLastFailStatus, getLevelWarningCount } from '../errorConvertor';
import { getStatusStateInfo } from '../status';
import { PodBox } from './model';

export function getPodBox(boxStatus: TBoxStatus): PodBox {
   const { id, revision, state, inits, ip6_address, specific_type } = boxStatus;
   const box: PodBox = {
      id,
      state,
      revision: revision ?? null,
      targetRevision: null,
      statusStateInfo: getStatusStateInfo(boxStatus),
      initStatuses: (inits ?? []).map(getContainerLastFailStatus),
      ip6Address: ip6_address ?? null,
      warning: {},
      warningCount: 0,
      type: specific_type ?? 'default',
      isSystemBox: specific_type === 'system',
   };

   box.warning = getBoxWarning(box);
   box.warningCount = getLevelWarningCount(box.warning);

   return box;
}
