import { TLayerStatus } from '../../../../proto-typings';
import { getLayerWarning, getLevelWarningCount } from '../errorConvertor';
import { getStatusStateInfo } from '../status';
import { PodLayer } from './model';

export function getPodLayer(layerStatus: TLayerStatus): PodLayer {
   const { id, revision, state, download_progress } = layerStatus;
   const layer: PodLayer = {
      id,
      state,
      downloadProgress: download_progress ?? null,
      revision: revision ?? null,
      targetRevision: null,
      statusStateInfo: getStatusStateInfo(layerStatus),
      warning: {},
      warningCount: 0,
   };

   layer.warning = getLayerWarning(layer);
   layer.warningCount = getLevelWarningCount(layer.warning);

   return layer;
}
