import { TStaticResourceStatus } from '../../../../proto-typings';
import { getLevelWarningCount, getStaticResourceWarning } from '../errorConvertor';
import { getStatusStateInfo } from '../status';
import { PodStaticResource } from './model';

export function getPodStatisResource(resourceStatus: TStaticResourceStatus): PodStaticResource {
   const { id, revision, state, download_progress } = resourceStatus;
   const resource: PodStaticResource = {
      id,
      state,
      downloadProgress: download_progress ?? null,
      revision: revision ?? null,
      targetRevision: null,
      statusStateInfo: getStatusStateInfo(resourceStatus),
      warning: {},
      warningCount: 0,
   };

   resource.warning = getStaticResourceWarning(resource);
   resource.warningCount = getLevelWarningCount(resource.warning);

   return resource;
}
