import { TVolumeStatus } from '../../../../proto-typings';
import { getLevelWarningCount, getVolumeWarning } from '../errorConvertor';
import { getStatusStateInfo } from '../status';
import { PodVolume } from './model';

export function getPodVolume(volumeStatus: TVolumeStatus): PodVolume {
   const { id, revision, state } = volumeStatus;
   const volume: PodVolume = {
      id,
      state,
      revision: revision ?? null,
      targetRevision: null,
      statusStateInfo: getStatusStateInfo(volumeStatus),
      warning: {},
      warningCount: 0,
   };

   volume.warning = getVolumeWarning(volume);
   volume.warningCount = getLevelWarningCount(volume.warning);

   return volume;
}
