import { TWorkload, TWorkloadStatus } from '../../../../proto-typings';
import {
   getContainerLastFailStatus,
   getLevelWarningCount,
   getProbeFailStatus,
   getStartContainerLastFailStatus,
   getWorkloadWarning,
} from '../errorConvertor';
import { getStatusStateInfo } from '../status';
import { PodWorkload } from './model';

export function getPodWorkload(workloadStatus: TWorkloadStatus, workloadSpec: TWorkload | null): PodWorkload {
   const {
      destroy_status,
      id,
      init,
      liveness_status,
      readiness_status,
      revision,
      start,
      state,
      stop_status,
   } = workloadStatus;
   const { box_ref } = workloadSpec ?? {};

   const podWorkload: PodWorkload = {
      id,
      boxId: box_ref ?? null,
      state,
      revision: revision ?? null,
      targetRevision: null,
      statusStateInfo: getStatusStateInfo(workloadStatus),
      startStatus: getStartContainerLastFailStatus(start ?? null),
      initStatuses: (init ?? []).map(getContainerLastFailStatus),
      livenessStatus: getProbeFailStatus(liveness_status ?? null),
      readinessStatus: getProbeFailStatus(readiness_status ?? null),
      stopStatus: getProbeFailStatus(stop_status ?? null),
      destroyStatus: getProbeFailStatus(destroy_status ?? null),
      warning: {},
      warningCount: 0,
   };

   podWorkload.warning = getWorkloadWarning(podWorkload);
   podWorkload.warningCount = getLevelWarningCount(podWorkload.warning);

   return podWorkload;
}
