import { DeployUnit } from '../../stage';
import { DeployUnitStatus } from '../../stage/DeployUnit/DeployUnitStatusConverter';
import { ReplicaSetDisruptionBudgets, ReplicaSetInfo, ReplicaSetType } from './model';

export function getReplicaSetDisruptionBudgets(
   replicaSetInfo: ReplicaSetInfo,
   deployUnit: DeployUnit,
   deployUnitStatus: DeployUnitStatus,
): ReplicaSetDisruptionBudgets {
   const { locations, type } = replicaSetInfo;

   /** only for `ReplicaSetType.PerCluster` */
   const perClusterReplicaSetLocation = type === ReplicaSetType.PerCluster ? Array.from(locations.values())[0] : null;

   const { disruptionBudget: multiClusterDisruptionBudget, locations: duLocations, revision: duRevison } = deployUnit;
   const { overrides } = deployUnitStatus;

   let specDisruptionBudget: number | null = null;
   if (type === ReplicaSetType.PerCluster) {
      specDisruptionBudget = perClusterReplicaSetLocation
         ? duLocations[perClusterReplicaSetLocation]?.disruptionBudget
         : null;
   } else {
      specDisruptionBudget = multiClusterDisruptionBudget;
   }
   specDisruptionBudget = specDisruptionBudget ?? 0;

   let overrideDisruptionBudget: number | null = null;
   let overrideDisruptionBudgetAuthor: string | null = null;

   if (overrides) {
      const { perCluster, revision: revisionToOverride } = overrides;
      if (duRevison === revisionToOverride) {
         // multi -> https://a.yandex-team.ru/search?search=%22multi%22,%5Eyp.*,,arcadia,,5000&repo=arc
         const overrideLocation = type === ReplicaSetType.PerCluster ? perClusterReplicaSetLocation : 'multi';
         const overridePerCluster = overrideLocation ? perCluster[overrideLocation] : null;
         if (overridePerCluster) {
            const { maxUnavailable } = overridePerCluster;
            overrideDisruptionBudget = maxUnavailable.value ?? 0; // поле с 0 не возвращается yp
            overrideDisruptionBudgetAuthor = maxUnavailable.meta.login;
         }
      }
   }

   return {
      spec: {
         value: specDisruptionBudget,
      },
      override:
         overrideDisruptionBudget !== null
            ? {
                 value: overrideDisruptionBudget,
                 author: overrideDisruptionBudgetAuthor!,
              }
            : null,
   };
}
