import { TDeployUnitStatus } from '../../../../proto-typings';
import { createKey } from '../../../../utils';
import { YpLocation } from '../../../api';
import { ReplicaSetEndpointSets, ReplicaSetsInfo, ReplicaSetType } from './model';

export function getDeployUnitReplicaSetsInfo(deployUnitStatus: TDeployUnitStatus): ReplicaSetsInfo {
   const replicaSets: ReplicaSetsInfo = {};

   if (deployUnitStatus.replica_set && deployUnitStatus.replica_set.cluster_statuses) {
      const locationsData = deployUnitStatus.replica_set.cluster_statuses;

      for (const location of Object.keys(locationsData)) {
         const data = locationsData[location];
         const id = data.replica_set_id;
         const endpointSets = data.endpoint_set_ids ?? [data.endpoint_set_id];

         const key = createKey({ id, location });

         replicaSets[key] = {
            id,
            type: ReplicaSetType.PerCluster,
            locations: new Set([location]),
            endpointSets: {
               [location]: new Set(endpointSets),
            },
         };
      }
   } else if (
      deployUnitStatus.multi_cluster_replica_set &&
      deployUnitStatus.multi_cluster_replica_set.cluster_statuses
   ) {
      const locationsData = deployUnitStatus.multi_cluster_replica_set.cluster_statuses;

      const endpointSetsData: ReplicaSetEndpointSets = {};

      for (const location of Object.keys(locationsData)) {
         const data = locationsData[location];
         const endpointSets = data.endpoint_set_ids ?? [data.endpoint_set_id];

         endpointSetsData[location] = new Set(endpointSets);
      }

      const id = deployUnitStatus.multi_cluster_replica_set.replica_set_id;

      const key = createKey({ id, location: YpLocation.XDC });

      replicaSets[key] = {
         id,
         type: ReplicaSetType.MultiCluster,
         locations: new Set(Object.keys(locationsData)),
         endpointSets: endpointSetsData,
      };
   }

   return replicaSets;
}
