import { StatusStateInfo } from '../status';

export enum ReplicaSetType {
   PerCluster = 'PerCluster',
   MultiCluster = 'MultiCluster',
}

export interface ReplicaSetPodsSummary {
   total: number;
   ready: number;
   inProgress: number;
   failed: number;
   oldReady: number;
   oldInProgress: number;
   oldFailed: number;
   unavailable: number; // только для MCRS
   unknown: number;
}

export const getEmptyReplicaSetPodsSummary: () => ReplicaSetPodsSummary = () => ({
   total: 0,
   ready: 0,
   inProgress: 0,
   failed: 0,
   oldReady: 0,
   oldInProgress: 0,
   oldFailed: 0,
   unavailable: 0,
   unknown: 0,
});

export interface ReplicaSetConditionData {
   status: boolean | null;
   reason: string | null;
   message: string | null;
}

export type ReplicaSetEndpointSets = Record<string, Set<string>>; // location -> endpointSetIds[]

export type ReplicaSetLabels = {
   'yd.deploy_speed': Object | null;
};

export interface ReplicaSet {
   id: string;
   type: ReplicaSetType;
   currentRevision: number | null;
   targetRevision: number | null;
   location: string;
   locations: Set<string>;
   podsSummary: ReplicaSetPodsSummary;
   podsSummaryByLocation: Record<string, ReplicaSetPodsSummary>;
   lastAttemptMessages: Map<string, string>;
   statusStateInfo: StatusStateInfo;
   labels: ReplicaSetLabels;
}

export interface ReplicaSetInfo {
   id: string;
   type: ReplicaSetType;
   locations: Set<string>;
   endpointSets: ReplicaSetEndpointSets;
}

/** id=\<id>&location=\<location> -> data
 * @example
 * {
 *    "id=nikolaichev-stage-per-location.deployUnit&location=man": {
 *       "id": "nikolaichev-stage-per-location.deployUnit",
 *       "type": "PerCluster",
 *       "locations": Set(1) { "man" },
 *       "endpointSets": {
 *          "man":Set(1) { "nikolaichev-stage-per-location.deployUnit" }
 *       }
 *    }
 * }
 */
export interface ReplicaSetsInfo {
   [key: string]: ReplicaSetInfo;
}

export interface ReplicaSetDisruptionBudgets {
   spec: { value: number };
   override: {
      value: number;
      author: string;
   } | null;
}
