import { TError } from '../../../proto-typings';
import { StatusInfo } from './status';

export type TerminalTail = 'stderr' | 'stdout';
export type FailStatusTime = 'start' | 'death' | 'send';
export interface FailStatus {
   failReason: string | null;
   terminalTails: Map<TerminalTail, string>;
   times: Map<FailStatusTime, number>;
}

export const getDefaultFailStatus: () => FailStatus = () => ({
   failReason: null,
   terminalTails: new Map(),
   times: new Map(),
});

/**
 * Все возможные форматы ошибок
 */
export interface WarningData {
   error?: TError; // внутренняя ошибка YP
   failed?: StatusInfo; // ошибка агентов
   failStatus?: FailStatus; // ошибка отдельный частей (например, проб)
   message?: string; // текстовое описание, которое не укладывается в остальные форматы
   meta?: {
      locations?: Set<string>; // локации для кросс-дц сущностей
   };
}

/**
 * Данные для ошибок, T отличное от string нужно только для задания ошибок, для вывода — string
 */
export type WarningLevelData<T extends string> = Partial<Record<T, WarningData[]>>;
