export enum ResourceState {
   BROKEN = 'BROKEN',
   DELETED = 'DELETED',
   READY = 'READY',
   NOT_READY = 'NOT_READY',
}

/** https://a.yandex-team.ru/arc/trunk/arcadia/sandbox/web/api/v1/schemas/resource.py */
export interface SandboxResource {
   id: number;
   description: string;
   state: ResourceState;
   type: string;
   time: {
      accessed: string;
      created: string;
      expires: string;
      updated: string;
   };
   attributes: Record<string, string>;
}
