import { SecretResolver } from '../../../modules/secrets';

import { LinkToSecret } from './LinkToSecret';

export function extractActualAlias(
   linkToSecret: LinkToSecret | null,
   secretResolver: SecretResolver,
   stageId: string,
   duId: string,
) {
   return linkToSecret
      ? secretResolver // this check for unit tests only, normally secretResolver will be defined
         ? secretResolver.getActualAlias(stageId, duId, linkToSecret.alias)
         : linkToSecret.alias
      : undefined;
}
