import { getSecretUsagePath } from './getSecretUsagePath';

describe('models/ui/getSecretUsagePath', () => {
   it('should get for TVM', () => {
      expect(getSecretUsagePath({ field: `tvm.clients[2].secret` })).toBe('tvm.clients[2].secret');
   });

   it('should get for box environment', () => {
      expect(getSecretUsagePath({ field: 'environment', boxId: 'mySuperBox' })).toBe('boxes[mySuperBox].environment');
   });

   it('should get for workload environment', () => {
      expect(getSecretUsagePath({ field: 'environment', boxId: 'mySuperBox', workloadId: 'myWl' })).toBe(
         'boxes[mySuperBox].workloads[myWl].environment',
      );
   });
});
