interface GetSecretUsagePathParams {
   field: string;
   boxId?: string;
   workloadId?: string;
}

export function getSecretUsagePath({ field, boxId, workloadId }: GetSecretUsagePathParams): string {
   const parts: string[] = [];

   if (boxId) {
      parts.push(`boxes[${boxId}].`);
   }

   if (workloadId) {
      parts.push(`workloads[${workloadId}].`);
   }

   parts.push(field);

   return parts.join('');
}
