import { SecretResolver } from '../../../modules/secrets';
import { SecretSelector } from '../../../proto-typings';

import { patchString, skipEmpty } from '../utils';
import { extractActualAlias } from './extractActualAlias';
import { LinkToSecret } from './LinkToSecret';

export function patchSecret(
   secretSelector: SecretSelector,
   linkToSecret: LinkToSecret | null,
   secretResolver: SecretResolver,
   stageId: string,
   duId: string,
) {
   patchString(secretSelector, 'id', () => skipEmpty(linkToSecret?.key));

   patchString(secretSelector, 'alias', () => extractActualAlias(linkToSecret, secretResolver, stageId, duId));
}
