interface NodeWithIds {
   initialId?: string;
   id: string;
}

/**
 * Класс, используется для хранения информации о родителях узла стейджа, в патчерах (задаёт контекст)
 *
 * Изначально нужен для передачи информации о stageId и duId в patchSecrets.
 * Эта информация используется, чтобы вытянуть актуальный алиас секрета.
 *
 * В будущем может понадобиться для сходных задач, когда в патчере потребуется родительский контекст.
 */
export class StageParentNodeIds {
   public stageId: string;

   public duId?: string;

   public boxId?: string;

   constructor(private stage: NodeWithIds, private du?: NodeWithIds, box?: NodeWithIds) {
      this.stageId = StageParentNodeIds.getId(stage);

      if (du) {
         this.duId = StageParentNodeIds.getId(du);
      }

      if (box) {
         this.boxId = StageParentNodeIds.getId(box);
      }
   }

   public withDuId(du: NodeWithIds): StageParentNodeIds {
      return new StageParentNodeIds(this.stage, du);
   }

   public withBoxId(box: NodeWithIds): StageParentNodeIds {
      return new StageParentNodeIds(this.stage, this.du, box);
   }

   /**
    * Выбирает преимущественно initialId узла, как более стабильный (id можно редактировать)
    */
   private static getId(node: NodeWithIds) {
      return node.initialId ?? node.id;
   }
}
