import type { AnySubForm } from '../../../components/huge-form';
import { stageLevels } from './stage-levels';

export interface StageFormInitialIds {
   deployUnit: string;
   box: string;
   workload: string;
}
export function getInitialIds(
   formParams: AnySubForm['formParams'],
   parentForms: AnySubForm[],
   levelId: string,
): StageFormInitialIds {
   let duId = '';
   let boxId = '';
   let workloadId = '';

   const { initialId } = formParams;

   switch (levelId) {
      case stageLevels.deployUnit.id: {
         duId = initialId;
         break;
      }
      case stageLevels.box.id: {
         boxId = initialId;
         duId = parentForms[0].formParams.initialId;
         break;
      }
      case stageLevels.workload.id: {
         workloadId = initialId;
         boxId = parentForms[0].formParams.initialId;
         duId = parentForms[1].formParams.initialId;
         break;
      }
   }

   return { deployUnit: duId, box: boxId, workload: workloadId };
}
