import { TStage } from '../../../../proto-typings';

export interface StageSpecLocations {
   deployUnitId: string | null;
   boxId: string | null;
   workloadId: string | null;
   isResource: boolean;
}

/**
 * определение положения в спеке стейджа по yp пути
 */
export function getStageSpecLocations(rawStage: TStage | null, path: string): StageSpecLocations {
   const locations: StageSpecLocations = {
      deployUnitId: null,
      boxId: null,
      workloadId: null,
      isResource: false,
   };

   if (!rawStage) {
      return locations;
   }

   const list = path.split('/').filter(e => e);
   const checkTail = (checkPath: string, i: number) => {
      for (const item of checkPath
         .split('/')
         .filter(e => e)
         .reverse()) {
         if (item !== list[i]) {
            return false;
         }
         i -= 1;
      }
      return true;
   };
   let part: any = rawStage;
   for (let i = 0; i < list.length; i += 1) {
      const key = list[i];
      part = part[key];
      if (part === null) {
         break;
      }
      if (typeof part !== 'object') {
         break;
      }
      if (checkTail('spec/deploy_units', i - 1)) {
         locations.deployUnitId = key;
      } else if (checkTail('pod_agent_payload/spec/boxes', i - 1)) {
         locations.boxId = part.id;
      } else if (checkTail('pod_agent_payload/spec/workloads', i - 1)) {
         locations.workloadId = part.id;
         locations.boxId = part.box_ref;
      } else if (checkTail('pod_agent_payload/spec/resources', i - 1)) {
         locations.isResource = true;
      }
   }

   return locations;
}
