import { getHistoryEventTimestamp, HistoryEvent } from '../history';

export function getHistoryEventStageRevision(historyEvent: HistoryEvent): number {
   return historyEvent.result.spec.revision;
}

export const getListWithUniqRevisions = (list: HistoryEvent[] = []) => {
   const result: Record<string, HistoryEvent> = {};
   for (const event of list) {
      const revision = getHistoryEventStageRevision(event);
      if (!(revision in result) || getHistoryEventTimestamp(event) < getHistoryEventTimestamp(result[revision])) {
         // first event
         result[getHistoryEventStageRevision(event)] = event;
      }
   }
   return Object.values(result).sort(
      (a, b_) => Number(getHistoryEventStageRevision(b_)) - Number(getHistoryEventStageRevision(a)),
   );
};
