import { DeployUnitDisk, DiskType } from './index';
import { getBoxDiskType, getDuDiskType, getVolumeDiskType } from './resources';

const disks: DeployUnitDisk[] = [
   {
      id: 'disk_hdd',
      bandwidth: {
         guarantee: 99,
         limit: {
            defaultSettings: false,
            default: 123,
            custom: 456,
         },
      },
      size: 1,
      type: DiskType.HDD,
      volumes: [
         {
            id: 'hdd1',
         },
         {
            id: 'hdd2',
         },
         {
            id: 'hdd3',
         },
      ],
   } as any,
   {
      id: 'disk_ssd',
      bandwidth: {
         guarantee: 99,
         limit: {
            defaultSettings: false,
            default: 123,
            custom: 456,
         },
      },
      size: 1,
      type: DiskType.SSD,
      volumes: [
         {
            id: 'ssd1',
         },
         {
            id: 'ssd2',
         },
         {
            id: 'ssd3',
         },
      ],
   },
];

describe('resources', () => {
   describe('getVolumeDiskType', () => {
      it('HDD', () => {
         expect(getVolumeDiskType(disks, 'hdd1')).toBe(DiskType.HDD);
         expect(getVolumeDiskType(disks, 'hdd2')).toBe(DiskType.HDD);
         expect(getVolumeDiskType(disks, 'hdd3')).toBe(DiskType.HDD);
      });

      it('SSD', () => {
         expect(getVolumeDiskType(disks, 'ssd1')).toBe(DiskType.SSD);
         expect(getVolumeDiskType(disks, 'ssd2')).toBe(DiskType.SSD);
         expect(getVolumeDiskType(disks, 'ssd3')).toBe(DiskType.SSD);
      });

      it('incorrect', () => {
         expect(getVolumeDiskType(disks, 'incorrect_volume_id')).toBe(null);
      });
   });

   describe('getDuDiskType', () => {
      it('HDD', () => {
         expect(getDuDiskType(disks)).toBe(DiskType.HDD);
      });
   });

   describe('getBoxDiskType', () => {
      it('HDD', () => {
         expect(getBoxDiskType(disks, 'disk_hdd')).toBe(DiskType.HDD);
      });

      it('SSD', () => {
         expect(getBoxDiskType(disks, 'disk_ssd')).toBe(DiskType.SSD);
      });
   });
});
