export const stageLevels = {
   stage: {
      id: 'stage',
      level: 0,
   },
   deployUnit: {
      id: 'deployUnit',
      level: 1,
   },
   box: {
      id: 'box',
      level: 2,
   },
   workload: {
      id: 'workload',
      level: 3,
   },
} as const;

type StageLevels = typeof stageLevels;
type EntityLevel = {
   [K in keyof StageLevels as StageLevels[K]['id']]: StageLevels[K]['level'];
};

export const entityLevel: EntityLevel = Object.fromEntries(
   Object.values(stageLevels).map(({ id, level }) => [id, level]),
) as any;

// empty params
// наследуются в обратном порядке, от корня к потомкам

export type StageEmptyParams = {
   projectId?: string;
};

export type DeployUnitEmptyParams = StageEmptyParams & {};

export type BoxEmptyParams = DeployUnitEmptyParams & {};

export type WorkloadEmptyParams = BoxEmptyParams & {};
