import { YpLocation } from '../../../api';
import { ReplicaSet, ReplicaSetDisruptionBudgets, ReplicaSetInfo, ReplicaSetPodsSummary } from '../../runtimeDeploy';
import { MergeStatusStateInfo } from '../mergeStatus';

export type ReplicaSetLocationInfo = {
   oneLocation: YpLocation | null;
   ypLocation: YpLocation;
};

export type ReplicaSetStatusView = ReplicaSet & {
   __type: 'ReplicaSetStatusView';
   actualPodsSummary: ReplicaSetPodsSummary;
   mergePodsSummary: ReplicaSetPodsSummary;

   mergeStatusStateInfo: MergeStatusStateInfo;

   // поля из деплой-юнита, пустые, если нет деплой-юнита
   replicaSetInfo: ReplicaSetInfo | null;
   replicaSetDisruptionBudgets: ReplicaSetDisruptionBudgets | null;

   // информация о локациях
   replicaSetLocationInfo: ReplicaSetLocationInfo;

   // время последнего обновления
   lastUpdateTimestamp: number;
};
