import { DeployUnit, Stage, StageStatus, StageStatusLabel, DeployUnitStatus, DuStatusLabel } from '../../stage';

export type MergeDeployUnitStatusLabel = DuStatusLabel & { calculate: boolean };

export type DeployUnitStatusView = DeployUnitStatus & {
   spec: DeployUnit;

   deployUnitLabel: DuStatusLabel;

   // синтетический статус
   mergeDeployUnitLabel: MergeDeployUnitStatusLabel;

   // локации, ждущие апрува
   locationsWaitingForApprove: Map<string, boolean>;

   // хоть одна из локаций требует апрува
   waitingForApprove: boolean;

   // время последнего обновления
   lastUpdateTimestamp: number;
};

export type MergeStageStatusLabel = StageStatusLabel & { calculate: boolean };

export type StageStatusView = StageStatus & {
   spec: Stage;

   stageStatusLabel: StageStatusLabel;

   // синтетический статус
   mergeStageStatusLabel: MergeStageStatusLabel;

   // сколько du ждут апрува
   waitingForApproveDuCount: number;

   // время последнего обновления
   lastUpdateTimestamp: number;

   // все возможные локации; TODO: перенести в модель стейджа
   locations: Set<string>;

   // отключенные локации; TODO: перенести в модель стейджа
   disabledLocations: Set<string>;
};
